package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/25
 */
public interface ResourceByteMngService {

    /**
     * 保存资源文件
     *
     * @param multipartFile 资源文件
     * @param businessType  业务类型
     * @return 唯一标识
     */
    ApiResult<FileInfoVO> saveResource(@NotNull MultipartFile multipartFile, @NotBlank String businessType);

    /**
     * 删除资源
     *
     * @param id
     * @return
     */
    ApiResult<Long> delete(Long id);
}
