package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.dto.req.ThirdApiLogQueryDTO;
import com.elitescloud.cloudt.system.model.vo.query.extend.ThirdApiLogQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.ThirdApiRetryLogQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogAggPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogPageRespVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/4
 */
public interface ThirdApiLogService {

    /**
     * 分页查询日志
     *
     * @param requestDTO 查询参数
     * @return 日志列表
     */
    ApiResult<PagingVO<ThirdApiLogDTO>> queryByPage(ThirdApiLogQueryDTO requestDTO);

    /**
     * 分页查询日志
     *
     * @param queryVO 查询参数
     * @return 日志列表
     */
    ApiResult<PagingVO<ThirdApiLogPageRespVO>> queryByPage(ThirdApiLogQueryVO queryVO);

    /**
     * 查询重试记录列表
     *
     * @param originalId 原始ID
     * @return 重试记录列表
     */
    ApiResult<List<ThirdApiLogPageRespVO>> listRetryRecord(Long originalId);

    /**
     * 分页查询
     *
     * @param queryVO
     * @return
     */
    ApiResult<PagingVO<ThirdApiLogPageRespVO>> pageRetryRecord(ThirdApiRetryLogQueryVO queryVO);

    /**
     * 聚合查询
     *
     * @param queryVO 查询参数
     * @return 查询列表
     */
    ApiResult<PagingVO<ThirdApiLogAggPageRespVO>> queryAggByPage(ThirdApiLogQueryVO queryVO);

    /**
     * 获取聚合的明细
     *
     * @param queryVO 查询参数
     * @param id      选择的聚合记录ID
     * @return 明细列表
     */
    ApiResult<List<ThirdApiLogPageRespVO>> listAggDetail(ThirdApiLogQueryVO queryVO, Long id);

    /**
     * 分页查询明细
     *
     * @param queryVO 查询参数
     * @param id 选择的聚合记录ID
     * @return 明细列表
     */
    ApiResult<PagingVO<ThirdApiLogPageRespVO>> pageAggDetail(ThirdApiLogQueryVO queryVO, Long id);

    /**
     * 获取详细信息
     *
     * @param id 记录ID
     * @return 详细信息
     */
    ApiResult<ThirdApiLogDetailRespVO> getDetail(Long id);

    /**
     * 获取所有的业务类型
     *
     * @return 业务类型列表
     */
    ApiResult<List<CodeNameParam>> listBusinessTypes();

    /**
     * 获取所有的目标系统
     *
     * @return 业务类型列表
     */
    ApiResult<List<CodeNameParam>> listTargetSystems();

    /**
     * 获取所有的源系统
     *
     * @return 业务类型列表
     */
    ApiResult<List<CodeNameParam>> listSourceSystems();
}
