package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.extend.WechatMiniProgramRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.WechatServiceRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.WechatSubscriptionRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.WechatMiniProgramSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.WechatServiceSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.WechatSubscriptionSaveVO;

import javax.validation.constraints.NotNull;

/**
 * 第三方账号管理.
 *
 * @author Kaiser（wang shao）
 * @date 2/10/2023
 */
public interface ThirdPartAccountMngService {

    /**
     * 微信小程序保存
     *
     * @param saveVO 保存信息
     * @return 记录ID
     */
    ApiResult<Long> saveWechatMiniApp(WechatMiniProgramSaveVO saveVO, String businessType);

    /**
     * 获取微信小程序配置
     *
     * @return 微信小程序配置
     */
    ApiResult<WechatMiniProgramRespVO> getWechatMiniApp(String businessType);

    /**
     * 微信服务号保存
     *
     * @param saveVO 保存信息
     * @return 记录ID
     */
    ApiResult<Long> saveWechatService(WechatServiceSaveVO saveVO, String businessType);

    /**
     * 获取微信服务号配置
     *
     * @return 微信小程序配置
     */
    ApiResult<WechatServiceRespVO> getWechatService(String businessType);

    /**
     * 微信订阅号保存
     *
     * @param saveVO 保存信息
     * @return 记录ID
     */
    ApiResult<Long> saveWechatSubscription(WechatSubscriptionSaveVO saveVO, String businessType);

    /**
     * 获取微信订阅号配置
     *
     * @return 微信订阅号配置
     */
    ApiResult<WechatSubscriptionRespVO> getWechatSubscription(String businessType);

    /**
     * 更新casId
     *
     * @param id    账号ID
     * @param casId casId
     * @return 账号ID
     */
    ApiResult<Long> updateCasId(@NotNull Long id, Long casId);
}
