package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import lombok.extern.slf4j.Slf4j;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * API接口.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
@Slf4j
public class PlatformApiManageInitProvider extends AbstractBasicDataInitProvider {

    @Override
    public String typeName() {
        return "API接口";
    }

    @Override
    public String tableName() {
        return "sys_platform_api_manage";
    }

    @Override
    public List<String> fields() {
        return List.of("id", "app_code", "api_name", "api_code", "request_type", "api_path", "api_describe", "std_version",
                "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        Map<String, String> titles = new LinkedHashMap<>(16);
        titles.put("id", "ID");
        titles.put("app_code", "应用编码");
        titles.put("api_code", "API编码");
        titles.put("api_name", "API名称");
        titles.put("request_type", "请求类型");
        titles.put("api_path", "接口路径");
        titles.put("api_describe", "接口描述");
        titles.put("create_time", "创建时间");
        titles.put("modify_time", "最后修改时间");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc("create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "app_code";
    }

    @Override
    public UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        var apiCode = this.getStringValue(data, "api_code", null);
        Assert.notBlank(apiCode, "接口编码为空");

        data.put("original_id", getLongValue(data, "id", null));
        if (currentData.isEmpty()) {
            return UpdateType.ADD;
        }

        var id = currentData.stream()
                .filter(t -> apiCode.equals(t.get("api_code")))
                .findFirst()
                .map(t -> t.get("id"))
                .orElse(null);
        data.put("id", id);
        return id == null ? UpdateType.ADD : UpdateType.UPDATE;
    }
}
