package com.elitescloud.cloudt.system.service.impl;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.param.IdNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BaseNoticeDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BaseNoticeListRespVO;
import com.elitescloud.cloudt.system.service.common.constant.SysNoticeCategory;
import com.elitescloud.cloudt.system.service.model.entity.SysNoticeDO;
import com.elitescloud.cloudt.system.service.repo.NoticeRepoProc;
import com.elitescloud.cloudt.system.service.repo.NoticeTxtRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Slf4j
abstract class BaseNoticeService extends BaseServiceImpl {

    @Autowired
    protected NoticeRepoProc repoProc;
    @Autowired
    protected NoticeTxtRepoProc txtRepoProc;
    @Autowired
    protected UserRepoProc userRepoProc;

    @Autowired
    protected FileService fileService;

    protected <T extends BaseNoticeDetailRespVO> void fillDetailInfo(SysNoticeDO noticeDO, T noticeVO) {
        // 公告内容
        if (noticeDO.getTxtId() != null) {
            noticeVO.setTxt(txtRepoProc.getTxt(noticeDO.getTxtId()));
        }

        // 设置作者
        if (noticeVO.getAuthorId() != null) {
            tenantDataIsolateProvider.byDefaultDirectly(() -> {
                noticeVO.setAuthorName(userRepoProc.queryUserName(noticeVO.getAuthorId()));
                return null;
            });
        }

        // 分类
        noticeVO.setCategoryName(super.udcValue(new SysNoticeCategory(noticeVO.getCategory())));

        // 附件
        if (StringUtils.hasText(noticeDO.getFileCodesStr())) {
            com.el.coordinator.core.common.api.ApiResult<List<FileObjRespVO<?>>> fileResult = fileService.query(Arrays.asList(noticeDO.getFileCodesStr().split(",")));
            if (!fileResult.isSuccess()) {
                log.error("查询附件异常：{}, {}", noticeDO.getFileCodesStr(), fileResult.getMsg());
            }
            noticeVO.setFiles(fileResult.getData());
        }
    }

    protected <T extends BaseNoticeListRespVO> void fillListInfo(List<T> noticeList) {
        var authorIds = noticeList.stream().map(BaseNoticeListRespVO::getAuthorId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, IdNameParam> authorMap = authorIds.isEmpty() ? Collections.emptyMap() :
                tenantDataIsolateProvider.byDefaultDirectly(() -> userRepoProc.queryUserName(authorIds)).stream()
                        .collect(Collectors.toMap(IdNameParam::getId, Function.identity(), (t1, t2) -> t1));
        var categoryNameMap = super.udcMap(new SysNoticeCategory());

        noticeList.forEach(t -> {
            ObjUtil.ifNotNull(authorMap.get(t.getAuthorId()), a -> t.setAuthorName(a.getName()));
            t.setCategoryName(categoryNameMap.get(t.getCategory()));
        });
    }
}
