package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.service.ResourceByteMngService;
import com.elitescloud.cloudt.system.service.manager.ResourceByteMngManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/25
 */
@Service
public class ResourceByteMngServiceImpl extends BaseServiceImpl implements ResourceByteMngService {

    @Autowired
    private ResourceByteMngManager manager;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<FileInfoVO> saveResource(MultipartFile multipartFile, String businessType) {
        if (multipartFile == null || multipartFile.isEmpty()) {
            return ApiResult.fail("上传文件为空");
        }
        if (CharSequenceUtil.isBlank(businessType)) {
            return ApiResult.fail("业务类型为空");
        }

        var resource = manager.saveResource(multipartFile, businessType, null, true);
        return ApiResult.ok(resource);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> delete(Long id) {
        if (id == null) {
            return ApiResult.fail("ID为空");
        }

        manager.delete(id);
        return ApiResult.ok(id);
    }
}
