package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.service.RoleQueryService;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.manager.RoleMngManager;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleDO;
import com.elitescloud.cloudt.system.service.repo.RoleGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleRepoProc;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/17/2023
 */
@Service
@TenantTransaction(isolateType = TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg = false)
@Log4j2
public class RoleQueryServiceImpl extends BaseServiceImpl implements RoleQueryService {

    @Autowired
    private RoleRepoProc repoProc;
    @Autowired
    private RoleGroupRepoProc roleGroupRepoProc;

    @Override
    public ApiResult<List<IdCodeNameParam>> listRole(String businessKey, String roleName) {
        var dataList = repoProc.listQuery(BelongType.getBelonger(), businessKey, roleName);
        return ApiResult.ok(dataList);
    }

    @Override
    public ApiResult<Long> getIdByCode(String roleCode) {
        Assert.hasText(roleCode, "角色编码为空");

        var id = repoProc.getIdByCode(roleCode);
        return ApiResult.ok(id);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listCodeNamesById(Set<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail("ID为空");
        }

        var roles = repoProc.queryIdCodeNames(ids);
        return ApiResult.ok(roles);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listCodeNamesByCode(Set<String> codes) {
        if (CollUtil.isEmpty(codes)) {
            return ApiResult.fail("ID为空");
        }

        var roles = repoProc.queryIdCodeNamesByCode(codes);
        return ApiResult.ok(roles);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listAllRoleGroup(BelongType.Belonger belonger) {
        var groupList = roleGroupRepoProc.listIdCodeName(belonger, true);

        List<IdCodeNameParam> dataList = new ArrayList<>(groupList.size() + 4);
        dataList.add(new IdCodeNameParam(SysRoleDO.DEFAULT_GROUP_ID, "", SysRoleDO.DEFAULT_GROUP_NAME));
        dataList.addAll(groupList);
        return ApiResult.ok(dataList);
    }
}
