package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.common.BasicRecordStateEnum;
import com.elitescloud.cloudt.system.model.entity.QSysBasicRecordDO;
import com.elitescloud.cloudt.system.model.entity.SysBasicRecordDO;
import com.elitescloud.cloudt.system.model.vo.query.devops.BasicDataRecordPageQueryVO;
import com.elitescloud.cloudt.system.service.common.constant.BasicRecordTypeEnum;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/27
 */
@Repository
public class BasicRecordRepoProc extends BaseRepoProc<SysBasicRecordDO> {
    private static final QSysBasicRecordDO QDO = QSysBasicRecordDO.sysBasicRecordDO;

    public BasicRecordRepoProc() {
        super(QDO);
    }

    /**
     * 更细失败结果
     *
     * @param id
     * @param failReason
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateFailResult(long id, String failReason) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.finished, true)
                .set(QDO.success, false)
                .set(QDO.finishTime, LocalDateTime.now())
                .set(QDO.failReason, failReason)
                .where(QDO.id.eq(id))
                .execute();
    }

    /**
     * 更新导出成功
     *
     * @param id
     * @param fileCode
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateExportSuccessfully(long id, String fileCode, String attribute) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.finished, true)
                .set(QDO.success, true)
                .set(QDO.finishTime, LocalDateTime.now())
                .set(QDO.dataFileCode, fileCode)
                .set(QDO.attribute, attribute)
                .where(QDO.id.eq(id))
                .execute();
    }

    /**
     * 更新导入成功
     *
     * @param id
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateImportSuccessfully(long id) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.finished, true)
                .set(QDO.success, true)
                .set(QDO.finishTime, LocalDateTime.now())
                .where(QDO.id.eq(id))
                .execute();
    }

    /**
     * 更新状态
     *
     * @param id
     * @param state
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateState(long id, BasicRecordStateEnum state) {
        super.updateValue(QDO.state, state == null ? null : state.name(), id);
    }

    /**
     * 分页查询记录
     *
     * @param queryVO
     * @return
     */
    public PagingVO<SysBasicRecordDO> queryByPage(BasicDataRecordPageQueryVO queryVO, BasicRecordTypeEnum recordType) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.recordType, recordType)
                .andBetween(QDO.operateTime, queryVO.getStartTime(), queryVO.getEndTime())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), QDO.operateTime.desc());
    }
}
