package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformNextNumberDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNextNumberDO;
import com.elitescloud.cloudt.system.model.bo.SysSeqNextNumberBO;
import com.elitescloud.cloudt.system.model.vo.query.sequence.SeqNumPageQueryVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/11/14
 */
@Repository
public class SeqNextNumRepoProc extends BaseRepoProc<SysPlatformNextNumberDO> {
    private static final QSysPlatformNextNumberDO QDO = QSysPlatformNextNumberDO.sysPlatformNextNumberDO;

    public SeqNextNumRepoProc() {
        super(QDO);
    }

    /**
     * 更新启用状态
     *
     * @param id
     * @param enabled
     */
    public void updateEnabled(long id, boolean enabled) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    public boolean updateValue(long id, long nextNumber, @NotNull LocalDateTime nnTime, int version) {
        return jpaQueryFactory.update(QDO)
                .set(QDO.nextNumber, nextNumber)
                .set(QDO.nnTime, nnTime)
                .set(QDO.version, version + 1)
                .where(QDO.id.eq(id).and(QDO.version.eq(version)))
                .execute() > 0;
    }

    /**
     * 判断编号是否存在
     *
     * @param appCode
     * @param code
     * @return
     */
    public boolean existsCode(@NotBlank String appCode, @NotBlank String code) {
        return jpaQueryFactory.select(QDO.id)
                .from(QDO)
                .where(QDO.code.eq(code).and(QDO.appCode.eq(appCode)))
                .limit(1)
                .fetchOne() != null;
    }

    /**
     * 判断编号是否存在
     *
     * @param code
     * @return
     */
    public boolean existsCode(@NotBlank String code) {
        return super.exists(QDO.code, code);
    }

    /**
     * 获取编号
     *
     * @param id
     * @return
     */
    private String getCode(@NotNull Long id) {
        return super.getValue(QDO.code, id);
    }

    /**
     * 获取启用状态
     *
     * @param id
     * @return
     */
    public Boolean getEnabled(@NotNull Long id) {
        return super.getValue(QDO.enabled, id);
    }

    /**
     * 根据编码获取ID
     *
     * @param appCode
     * @param code
     * @return
     */
    public Long getIdByCode(@NotBlank String appCode, @NotBlank String code) {
        return jpaQueryFactory.select(QDO.id)
                .from(QDO)
                .where(QDO.code.eq(code).and(QDO.appCode.eq(appCode)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取所有的编码
     *
     * @param appCode
     * @return
     */
    public List<String> allCodes(@NotBlank String appCode) {
        return jpaQueryFactory.select(QDO.code)
                .from(QDO)
                .where(QDO.appCode.eq(appCode))
                .fetch();
    }

    /**
     * 根据编号获取对象
     *
     * @param appCode
     * @param code
     * @return
     */
    public SysPlatformNextNumberDO getByCode(@NotBlank String appCode, @NotBlank String code) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.code.eq(code).and(QDO.appCode.eq(appCode)))
                .limit(1)
                .fetchOne();
    }
    public List<SysPlatformNextNumberDO> getByCode(@NotBlank String appCode, @NotEmpty Collection<String> codes) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.code.in(codes).and(QDO.appCode.eq(appCode)))
                .fetch();
    }

    /**
     * 根据编号获取对象
     *
     * @param code
     * @return
     */
    public SysPlatformNextNumberDO getByCode(@NotBlank String code) {
        return super.getOneByValue(QDO.code, code);
    }

    public List<SysPlatformNextNumberDO> getByCode(@NotEmpty Collection<String> codes) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.code.in(codes))
                .fetch();
    }

    /**
     * 根据编号获取对象
     *
     * @param appCode
     * @param code
     * @return
     */
    public SysSeqNextNumberBO getBoByCode(@NotBlank String appCode, @NotBlank String code) {
        return jpaQueryFactory.select(qBeanBo())
                .from(QDO)
                .where(QDO.code.eq(code).and(QDO.appCode.eq(appCode)))
                .limit(1)
                .fetchOne();
    }

    public List<SysSeqNextNumberBO> getBoByCode(@NotBlank String appCode, @NotEmpty Collection<String> codes) {
        return jpaQueryFactory.select(qBeanBo())
                .from(QDO)
                .where(QDO.code.in(codes).and(QDO.appCode.eq(appCode)))
                .fetch();
    }

    /**
     * 根据编号获取对象
     *
     * @param code
     * @return
     */
    public SysSeqNextNumberBO getBoByCode(@NotBlank String code) {
        return jpaQueryFactory.select(qBeanBo())
                .from(QDO)
                .where(QDO.code.eq(code))
                .limit(1)
                .fetchOne();
    }
    public List<SysSeqNextNumberBO> getBoByCode(@NotEmpty Collection<String> codes) {
        return jpaQueryFactory.select(qBeanBo())
                .from(QDO)
                .where(QDO.code.in(codes))
                .fetch();
    }

    /**
     * 获取对象
     *
     * @param id
     * @return
     */
    public SysSeqNextNumberBO getBo(@NotNull Long id) {
        return jpaQueryFactory.select(qBeanBo())
                .from(QDO)
                .where(QDO.id.eq(id))
                .limit(1)
                .fetchOne();
    }

    /**
     * 分页查询管理
     *
     * @param queryVO
     * @return
     */
    public PagingVO<SysPlatformNextNumberDO> pageMng(@NotNull SeqNumPageQueryVO queryVO) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(StringUtils.hasText(queryVO.getAppCode()), QDO.appCode, queryVO.getAppCode())
                .andLike(StringUtils.hasText(queryVO.getName()), QDO.name, queryVO.getName())
                .andLike(StringUtils.hasText(queryVO.getCode()), QDO.code, queryVO.getCode())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }

    /**
     * 分页查询
     *
     * @param page
     * @param pageSize
     * @param appCode
     * @return
     */
    public PagingVO<SysSeqNextNumberBO> pageBo(int page, int pageSize, @NotBlank String appCode) {
        var jpaQuery = jpaQueryFactory.select(qBeanBo())
                .from(QDO)
                .where(QDO.appCode.eq(appCode));
        return super.queryByPage(jpaQuery, super.ofPage(page, pageSize));
    }



    private QBean<SysSeqNextNumberBO> qBeanBo() {
        return Projections.bean(SysSeqNextNumberBO.class, QDO.id, QDO.appCode, QDO.code, QDO.name,
                QDO.step, QDO.nextNumber, QDO.nnPeriod, QDO.nnTime, QDO.version, QDO.enabled, QDO.remark);
    }
}
