package com.elitescloud.cloudt.ucenter.api.vo.save;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Evin.dong
 * @date 2021-05-19
 */
@Data
@ApiModel(description = "广告位新增编辑入参")
public class AdSpaceSaveVO extends BaseModel {

    @ApiModelProperty(value = "广告位名称")
    @NotBlank(message = "广告位名称不能为空")
    private String adSpaceName;

    @ApiModelProperty(value = "广告位说明")
    private String adSpaceDesc;

    @ApiModelProperty(value = "展现形式(wheel轮播/flat平铺/pop弹窗)")
    @NotBlank(message = "展现形式不能为空")
    private String showStyle;

}
