package com.elitescloud.cloudt.ucenter.controller;

import com.elitescloud.cloudt.common.base.ApiResult;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.*;
import com.elitescloud.cloudt.ucenter.api.vo.resp.*;
import com.elitescloud.cloudt.ucenter.api.vo.save.ArticleCategorySaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.ArticleInfoSaveVO;
import com.elitescloud.cloudt.ucenter.service.ArticleManageService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/article/manage", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "文章管理")
@Slf4j
@RequiredArgsConstructor
public class ArticleManageController {
    private final ArticleManageService articleManageService;

    @PostMapping(value = "category/search")
    @ApiOperation(value = "文章分类分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<ArticleCategoryRespVO>> search(@RequestBody ArticleCategoryPagingParam searchParam) {
        return ApiResult.ok(articleManageService.search(searchParam));
    }

    @PostMapping(value = "category/save")
    @ApiOperation(value = "编辑保存文章分类信息")
    @ApiOperationSupport(order = 2)
    public ApiResult<Long> articleCategorySave(@RequestBody @Validated ArticleCategorySaveVO saveVO) {
        return ApiResult.ok(articleManageService.saveOrUpdateArticleCategory(saveVO));
    }

    @DeleteMapping(value = "category/delete/{id}")
    @ApiOperation(value = "删除文章分类")
    @ApiOperationSupport(order = 3)
    public ApiResult<Long> deleteArticleCategory(@PathVariable Long id) {
        return ApiResult.ok(articleManageService.deleteArticleCategory(id));
    }

    @PostMapping(value = "/category/show/update")
    @ApiOperation(value = "文章分类显示/隐藏编辑")
    @ApiOperationSupport(order = 4)
    public ApiResult<Long> categoryShowUpdate(@RequestBody @Validated CategoryShowParam param) {
        return ApiResult.ok(articleManageService.categoryShowUpdate(param));
    }

    @PostMapping(value = "/category/sort/update")
    @ApiOperation(value = "文章分类排序编辑")
    @ApiOperationSupport(order = 5)
    public ApiResult<Integer> categorySortUpdate(@RequestBody @Validated ArticleCategorySortParam param) {
        return ApiResult.ok(articleManageService.categorySortUpdate(param));
    }

//    @GetMapping(value = "/up/category")
//    @ApiOperation(value = "获取上级分类")
//    @ApiOperationSupport(order = 6)
//    public ApiResult<List<ArticleCategoryRespVO>> queryUpCategory() {
//        List<ArticleCategoryRespVO> voList = articleManageService.queryUpCategory();
//        return ApiResult.ok(voList);
//    }

    @GetMapping(value = "/up/category/{id}")
    @ApiOperation(value = "获取上级分类")
    @ApiOperationSupport(order = 6)
    public ApiResult<List<UpCategoryRespVO>> queryUpCategory(@PathVariable Long id) {
        List<UpCategoryRespVO> voList = articleManageService.queryUpCategory(id);
        return ApiResult.ok(voList);
    }

    @PostMapping(value = "/info/search")
    @ApiOperation(value = "文章分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<ArticleInfoRespVO>> infoSearch(@RequestBody ArticleInfoPagingParam searchParam) {
        return ApiResult.ok(articleManageService.infoSearch(searchParam));
    }

    @PostMapping(value = "/info/save")
    @ApiOperation(value = "编辑保存文章信息")
    @ApiOperationSupport(order = 7)
    public ApiResult<Long> articleSave(@RequestBody @Validated ArticleInfoSaveVO saveVO) {
        return ApiResult.ok(articleManageService.saveOrUpdateArticleInfo(saveVO));
    }

    @DeleteMapping(value = "/info/delete/{id}")
    @ApiOperation(value = "删除文章信息")
    @ApiOperationSupport(order = 8)
    public ApiResult<Long> deleteArticleInfo(@PathVariable Long id) {
        return ApiResult.ok(articleManageService.deleteArticleInfo(id));
    }

    @PostMapping(value = "/info/show/update")
    @ApiOperation(value = "文章显示/隐藏编辑")
    @ApiOperationSupport(order = 9)
    public ApiResult<Integer> infoShowUpdate(@RequestBody @Validated ArticleInfoShowParam param) {
        return ApiResult.ok(articleManageService.infoShowUpdate(param));
    }

    @PostMapping(value = "/info/sort/update")
    @ApiOperation(value = "文章排序编辑")
    @ApiOperationSupport(order = 10)
    public ApiResult<Integer> infoSortUpdate(@RequestBody @Validated ArticleInfoSortParam param) {
        return ApiResult.ok(articleManageService.infoSortUpdate(param));
    }

    @GetMapping(value = "/info/detail/{id}")
    @ApiOperation(value = "文章详情")
    @ApiOperationSupport(order = 10)
    public ApiResult<ArticleInfoDetailRespVO> queryInfoDetail(@PathVariable Long id) {
        return ApiResult.ok(articleManageService.queryInfoDetail(id));
    }

    @GetMapping(value = "/all/category")
    @ApiOperation(value = "所有文章分类数据")
    @ApiOperationSupport(order = 6)
    public ApiResult<List<ArticleInfoCategoryRespVO>> queryAllCategory() {
        List<ArticleInfoCategoryRespVO> voList = articleManageService.queryAllCategory();
        return ApiResult.ok(voList);
    }

    @GetMapping(value = "/article/detail/{id}")
    @ApiOperation(value = "文章内容链接")
    @ApiOperationSupport(order = 6)
    public ApiResult<String> queryArticleDetail(@PathVariable Long id) {
        return ApiResult.ok(articleManageService.queryArticleDetail(id));
    }

    @GetMapping(value = "/category/article")
    @ApiOperation(value = "经销商文章分类信息")
    @ApiOperationSupport(order = 6)
    public ApiResult<?> queryCategoryArticle() {
        return ApiResult.ok(articleManageService.queryCategoryArticle());
    }
}