package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "sys_ad_space", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sys_ad_space", comment = "广告位信息")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class AdSpaceDO extends BaseModel implements Serializable {

    @Column(name = "ad_space_code")
    private String adSpaceCode;

    @Column(name = "ad_space_name")
    private String adSpaceName;

    @Column(name = "ad_space_desc")
    private String adSpaceDesc;

    @Column(name = "sort_no")
    private Integer sortNo;

    @Column(name = "show_style")
    private String showStyle;
}
