package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "sys_article_info", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sys_article_info", comment = "文章信息")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ArticleInfoDO extends BaseModel implements Serializable {

    @Column(name = "article_author")
    private String articleAuthor;

    @Column(name = "article_name")
    private String articleName;

    @Column(name = "article_code")
    private String articleCode;

    @Column(name = "sort_no")
    private Integer sortNo;

    @Column(name = "show_flag")
    private String showFlag;

    @Column(name = "category_id")
    private Long categoryId;

    @Column(name = "category_name")
    private String categoryName;

    @Column(name = "article_detail")
    private String articleDetail;
}
