package com.elitescloud.cloudt.ucenter.repo;

import com.elitescloud.cloudt.ucenter.entity.ArticleInfoDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Set;

/**
 * @auther JinXK
 * @date 2021/6/12 11:25
 */
public interface ArticleInfoRepo extends JpaRepository<ArticleInfoDO, Long>, QuerydslPredicateExecutor<ArticleInfoDO> {

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update sys_article_info set delete_flag = ?2 where id in ?1 and delete_flag='0'", nativeQuery = true)
    Integer deleteByIds(List<Long> list, String deleteFlag);

    @Transactional
    @Modifying
    @Query(value = "update sys_article_info set delete_flag = ?2 where category_id in ?1 and delete_flag='0'", nativeQuery = true)
    Integer deleteInfoByCategoryIds(List<Long> ids, String deleteFlag);

    boolean existsByArticleName(String articleName);

    boolean existsByArticleCode(String articleCode);

    ArticleInfoDO findByArticleNameAndCategoryId(String articleName, Long categoryId);

    @Transactional
    @Modifying
    @Query(value = "update sys_article_info set sort_no = ?2 where id = ?1", nativeQuery = true)
    Integer updateSortById(Long id, int sortNo);

    @Transactional
    @Modifying
    @Query(value = "update sys_article_info set show_flag = ?2 where id = ?1 ", nativeQuery = true)
    Integer updateShowById(Long id, String showFlag);

    @Transactional
    @Modifying
    @Query(value = "update sys_article_info set show_flag = ?2 where category_id = ?1", nativeQuery = true)
    Integer updateShowByCategoryId(Long categoryId, String showFlag);

    @Transactional
    @Modifying
    @Query(value = "update sys_article_info set delete_flag = 1 where category_id = ?1", nativeQuery = true)
    Integer updateDeleteFlagByCategoryId(Long id);

    @Transactional
    @Modifying
    @Query(value = "update sys_article_info set delete_flag = 1 where id = ?1", nativeQuery = true)
    Integer updateDeleteFlagById(Long id);

    List<ArticleInfoDO> findByCategoryIdAndShowFlag(Long categoryId, String showFlag);

    @Transactional
    @Modifying
    @Query(value = "update sys_article_info set delete_flag = 1 where category_id in ?1", nativeQuery = true)
    void updateDeleteFlagByCategoryIdIn(Set<Long> deleteIdSet);

    @Transactional
    @Modifying
    @Query(value = "update sys_article_info set show_flag = ?2 where category_id in ?1", nativeQuery = true)
    void updateShowByCategoryIdIn(Set<Long> set, String showFlag);
}
