package com.elitescloud.cloudt.ucenter.repo;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.CommonSearchDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.CommonSearchParam;
import com.elitescloud.cloudt.ucenter.common.constant.Constant;
import com.elitescloud.cloudt.ucenter.entity.QCommonSearchDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
@Component
@RequiredArgsConstructor
public class CommonSearchRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    
    private final QCommonSearchDO qCommonSearchDO = QCommonSearchDO.commonSearchDO;

    private JPAQuery<CommonSearchDTO> select(Class<CommonSearchDTO> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qCommonSearchDO.id,
                qCommonSearchDO.commonSearchId,
                qCommonSearchDO.commonSearchName,
                qCommonSearchDO.commonSearchContent,
                qCommonSearchDO.commonSearchParam,
                qCommonSearchDO.connectionName,
                qCommonSearchDO.databaseType,
                qCommonSearchDO.cacheFlag,
                qCommonSearchDO.cacheLiveTime,
                qCommonSearchDO.subSearch,
                qCommonSearchDO.userName,
                qCommonSearchDO.password
        )).from(qCommonSearchDO);
    }


    public List<CommonSearchDTO> query(CommonSearchParam commonSearchParam) {
        JPAQuery<CommonSearchDTO> jpaQuery = buildJpaQuery(commonSearchParam);
        return jpaQuery.fetch();
    }

    private JPAQuery<CommonSearchDTO> buildJpaQuery(CommonSearchParam commonSearchParam) {

        JPAQuery<CommonSearchDTO> jpaQuery = select(CommonSearchDTO.class);

        if(commonSearchParam.getId()!=null){
            jpaQuery.where(qCommonSearchDO.id.eq(commonSearchParam.getId()));
        }

        if (StringUtils.isNotEmpty(commonSearchParam.getCommonSearchName())) {
            jpaQuery.where(qCommonSearchDO.commonSearchName.like(buildLikeCondition(commonSearchParam.getCommonSearchName())));
        }

        if (StringUtils.isNotEmpty(commonSearchParam.getCommonSearchId())) {
            jpaQuery.where(qCommonSearchDO.commonSearchId.like(buildLikeCondition(commonSearchParam.getCommonSearchId())));
        }

        if (StringUtils.isNotEmpty(commonSearchParam.getCommonSearchContent())) {
            jpaQuery.where(qCommonSearchDO.commonSearchContent.like(buildLikeCondition(commonSearchParam.getCommonSearchContent())));
        }

        return jpaQuery;
    }

    private String buildLikeCondition(String condition){
        return Constant.PERCENTAGE.concat(condition).concat(Constant.PERCENTAGE);
    }


    public PagingVO<CommonSearchDTO> page(CommonSearchParam commonSearchParam) {
        JPAQuery<CommonSearchDTO> jpaQuery= buildJpaQuery(commonSearchParam);
        int size = jpaQuery.fetch().size();

        commonSearchParam.fillOrders(jpaQuery, qCommonSearchDO);
        commonSearchParam.setPaging(jpaQuery);

        return PagingVO.<CommonSearchDTO>builder()
                .total(size)
                .records(jpaQuery.fetch())
                .build();
    }
}
