package com.elitescloud.cloudt.datadiff.log.controller;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import com.elitescloud.cloudt.datadiff.log.service.SysDataModifyLogService;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogPageParamVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogSaveVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogRespVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogPageRespVO;

@Slf4j
@Api(tags = "数据变更日志")
@RestController
@RequestMapping(value = "/sysDataModifyLog", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class SysDataModifyLogController {

	private final SysDataModifyLogService sysDataModifyLogService;

	@ApiOperation("数据变更日志分页查询")
	@PostMapping("/page")
	public ApiResult<PagingVO<SysDataModifyLogPageRespVO>> page(@RequestBody SysDataModifyLogPageParamVO paramVO) {
		return ApiResult.ok(sysDataModifyLogService.page(paramVO));
	}

	@ApiOperation("数据变更日志查询详情信息")
	@GetMapping("/findIdOne/{id}")
	public ApiResult<SysDataModifyLogRespVO> findIdOne(@PathVariable Long id) {
		return sysDataModifyLogService.findById(id).map(ApiResult::ok)
			.orElse(ApiResult.fail(ApiCode.NOT_FOUND));
	}

	@ApiOperation("数据变更日志保存")
	@PostMapping("/save")
	public ApiResult<Long> save(@RequestBody @Validated SysDataModifyLogSaveVO saveVO) {
		return ApiResult.ok(sysDataModifyLogService.save(saveVO));
	}

	@ApiOperation("数据变更日志删除")
	@PostMapping("/delete")
	public ApiResult<Object> delete(@RequestBody List<Long> ids) {
		sysDataModifyLogService.deleteByIds(ids);
		return ApiResult.ok();
	}

}
