package com.elitescloud.cloudt.datadiff.log.domain;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.datadiff.log.entity.SysDataModifyLogDO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogPageParamVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogSaveVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogParamVO;
import com.elitescloud.cloudt.system.dto.SysDataModifyLogDTO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogRespVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogPageRespVO;
import org.springframework.transaction.annotation.Transactional;
import java.util.List;
import java.util.Optional;

/**
 * @author nc
 * @since 2025-08-21
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SysDataModifyLogDomainServiceImpl implements SysDataModifyLogDomainService{

	private final SysDataModifyLogRepo sysDataModifyLogRepo;
	private final SysDataModifyLogRepoProc sysDataModifyLogRepoProc;

	@Override
	public PagingVO<SysDataModifyLogPageRespVO> queryList(SysDataModifyLogPageParamVO paramVO) {
		long count = sysDataModifyLogRepoProc.countBy(paramVO);
		if (count > 0) {
			var list = sysDataModifyLogRepoProc.pageBy(paramVO);
			return new PagingVO<>(count, list);
		}
		return new PagingVO<>();
	}

	@Override
	public Optional<SysDataModifyLogDTO> findById(Long id) {
		return sysDataModifyLogRepo.findById(id).map(SysDataModifyLogConvert.INSTANCE::doToDto);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public Long save(SysDataModifyLogSaveVO saveVO) {
		if (saveVO.getId() == null) {
			SysDataModifyLogDO sysDataModifyLogDO = SysDataModifyLogConvert.INSTANCE.saveVoToDO(saveVO);
			return sysDataModifyLogRepo.save(sysDataModifyLogDO).getId();
		} else {
			Optional<SysDataModifyLogDO> option = sysDataModifyLogRepo.findById(saveVO.getId());
			if (option.isEmpty()) {
				throw new BusinessException("ID：" + saveVO.getId() + "不存在");
			}
			SysDataModifyLogDO sysDataModifyLogDO = option.get();
			SysDataModifyLogConvert.INSTANCE.copySaveParamToDo(saveVO, sysDataModifyLogDO);
			return sysDataModifyLogRepo.save(sysDataModifyLogDO).getId();
		}
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void deleteByIds(List<Long> ids) {
		sysDataModifyLogRepoProc.deleteByIds(ids);
	}

	@Override
	public List<SysDataModifyLogRespVO> findByParam(SysDataModifyLogParamVO paramVO) {
		return sysDataModifyLogRepoProc.findByParam(paramVO);
	}

}
