package com.elitescloud.cloudt.datadiff.log.domain;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.datadiff.log.entity.QSysDataModifyLogDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogPageParamVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogPageRespVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogRespVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogParamVO;
import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class SysDataModifyLogRepoProc {
    private final JPAQueryFactory jpaQueryFactory;

    private final QSysDataModifyLogDO sysDataModifyLogDO = QSysDataModifyLogDO.sysDataModifyLogDO;

    public long countBy(SysDataModifyLogPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(sysDataModifyLogDO.count())
                .from(sysDataModifyLogDO);
        Long count = jpaQuery.where(where(paramVO)).fetchOne();
        return count != null ? count : 0L;
    }

    private final QBean<SysDataModifyLogPageRespVO> pageList = Projections.bean(
            SysDataModifyLogPageRespVO.class,
            sysDataModifyLogDO.createTime,
            sysDataModifyLogDO.createUserId,
            sysDataModifyLogDO.creator,
            sysDataModifyLogDO.dataCode,
            sysDataModifyLogDO.dataId,
            sysDataModifyLogDO.deleteFlag,
            sysDataModifyLogDO.id,
            sysDataModifyLogDO.masId,
            sysDataModifyLogDO.masType
    );

    public List<SysDataModifyLogPageRespVO> pageBy(SysDataModifyLogPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(sysDataModifyLogDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, sysDataModifyLogDO);
        jpaQuery.where(where(paramVO));
        return jpaQuery.fetch();
   }

   private Predicate where(SysDataModifyLogPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDataCode())) {
            predicates.add(sysDataModifyLogDO.dataCode.eq(paramVO.getDataCode()));
        }
        if (paramVO.getDataId() != null) {
            predicates.add(sysDataModifyLogDO.dataId.eq(paramVO.getDataId()));
        }
        if (paramVO.getMasId() != null) {
            predicates.add(sysDataModifyLogDO.masId.eq(paramVO.getMasId()));
        }
        if (StrUtil.isNotBlank(paramVO.getMasType())) {
            predicates.add(sysDataModifyLogDO.masType.eq(paramVO.getMasType()));
        }
        return ExpressionUtils.allOf(predicates);
   }

   public long deleteByIds(List<Long> ids) {
       List<Predicate> predicates = new ArrayList<>();
       predicates.add(sysDataModifyLogDO.id.in(ids));
       var delete = jpaQueryFactory.delete(sysDataModifyLogDO)
               .where(ExpressionUtils.allOf(predicates));
       return delete.execute();
   }

   public List<SysDataModifyLogRespVO> findByParam(SysDataModifyLogParamVO paramVO) {
       List<Predicate> predicates = new ArrayList<>();
       var jpaQuery = jpaQueryFactory.select(Projections.bean(SysDataModifyLogRespVO.class,
                sysDataModifyLogDO.createTime,
                sysDataModifyLogDO.createUserId,
                sysDataModifyLogDO.creator,
                sysDataModifyLogDO.dataCode,
                sysDataModifyLogDO.dataId,
                sysDataModifyLogDO.deleteFlag,
                sysDataModifyLogDO.id,
                sysDataModifyLogDO.masId,
                sysDataModifyLogDO.masType
       )).from(sysDataModifyLogDO);

       jpaQuery.where(ExpressionUtils.allOf(predicates));
       return jpaQuery.fetch();
   }

}