package com.elitescloud.cloudt.datadiff.log.request;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDateTime;



/**
 * <p>
 * 数据变更日志
 * </p>
 *
 * @author nc
 * @since 2025-08-21
 */
@Data
@ApiModel
public class SysDataModifyLogSaveVO implements Serializable {

	private static final long serialVersionUID = 1L;


	/**
	 * 业务数据编码
	 */
	@ApiModelProperty(value = "业务数据编码")
	@Size(max = 255, message = "dataCode最大长度不得超过255")
	private String dataCode;

	/**
	 * 业务数据ID
	 */
	@ApiModelProperty(value = "业务数据ID")
	private Long dataId;

	private Long id;
	/**
	 * 业务单据ID
	 */
	@ApiModelProperty(value = "业务单据ID")
	@NotNull(message = "业务单据ID" + "不能为空")
	private Long masId;

	/**
	 * 业务单据类型(供应商变更,商品变更,客户变更)
	 */
	@ApiModelProperty(value = "业务单据类型(供应商变更,商品变更,客户变更)")
	@NotNull(message = "业务单据类型" + "不能为空")
	private String masType;

	@ApiModelProperty("变更人id")
	private Long modifyPersonId;

	@ApiModelProperty("变更人")
	private String modifyPerson;

	@ApiModelProperty("变更时间")
	private LocalDateTime modifyDate;
	/**
	 * 变更内容Json
	 */
	@ApiModelProperty(value = "变更内容Json")
	@NotNull(message = "变更内容Json" + "不能为空")
	private String modifyContentJson;

}