package com.elitescloud.cloudt.datadiff.log.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogPageParamVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogSaveVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogRespVO;
import com.elitescloud.cloudt.datadiff.log.domain.SysDataModifyLogDomainService;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogPageRespVO;
import com.elitescloud.cloudt.datadiff.log.domain.SysDataModifyLogConvert;



/**
 * <p>
 * SysDataModifyLogDO 变更日志服务层
 * </p>
 *
 * @author nc
 * @since 2025-08-21
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SysDataModifyLogServiceImpl implements SysDataModifyLogService{

	private final SysDataModifyLogDomainService sysDataModifyLogDomainService;

	@Override
	@SysCodeProc
    public PagingVO<SysDataModifyLogPageRespVO> page(SysDataModifyLogPageParamVO paramVO) {
        return sysDataModifyLogDomainService.queryList(paramVO);
    }

	@Override
	@SysCodeProc
	public Optional<SysDataModifyLogRespVO> findById(Long id) {
		return sysDataModifyLogDomainService.findById(id).map(SysDataModifyLogConvert.INSTANCE::dtoToRespVO);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public Long save(SysDataModifyLogSaveVO saveVO) {
		return sysDataModifyLogDomainService.save(saveVO);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void deleteByIds(List<Long> ids) {
		sysDataModifyLogDomainService.deleteByIds(ids);
	}

}
