package com.elitescloud.cloudt.datadiff.vo;

import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.datadiff.annotation.AuditField;
import com.elitescloud.cloudt.datadiff.annotation.AuditObject;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 测试类
 *
 * @author
 * @date 2/28/2023
 */
@Data
@AuditObject(name="员工信息")
public class TestVo implements Serializable {
    private static final long serialVersionUID = 2588133678930173478L;

    /**
     * 员工ID
     */
    @AuditField(fieldZhName = "员工ID")
    private Long id;

    /**
     * 员工编号
     */
    @AuditField(fieldZhName = "员工编号")
    private String code;


    /**
     * 入职时间
     */
    @AuditField(fieldZhName = "入职时间")
    private LocalDateTime joinTime;

    /**
     * 是否在职
     */
    @AuditField(fieldZhName = "是否在职")
    private Boolean served;


    /**
     * 生日
     */
    @AuditField(fieldZhName = "生日")
    private LocalDate birthDate;


    /**
     * 所在地
     */
    @AuditField(fieldZhName = "地址信息对象")
    private Test2Vo test2Vo;


    /**
     * 角色信息
     */
    @AuditField(fieldZhName = "财务信息集合")
    private List<Test3Vo> test3Vos;


}
