package com.elitescloud.cloudt.groupitem;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemPageParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveHeadVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemPageRespVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;



@Slf4j
@Api(tags = "员工组商品范围")
@RestController
@RequestMapping(value = "/sysEmployeeGroupItem", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class SysEmployeeGroupItemController {

	private final SysEmployeeGroupItemService sysEmployeeGroupItemService;

	@ApiOperation("员工组商品范围-分页查询")
	@PostMapping("/page")
	public ApiResult<PagingVO<SysEmployeeGroupItemPageRespVO>> page(@RequestBody SysEmployeeGroupItemPageParamVO paramVO) {
		return ApiResult.ok(sysEmployeeGroupItemService.page(paramVO));
	}

	@ApiOperation("员工组商品范围-查询详情信息")
	@GetMapping("/findIdOne/{id}")
	public ApiResult<SysEmployeeGroupItemRespVO> findIdOne(@PathVariable Long id) {
		return sysEmployeeGroupItemService.findById(id).map(ApiResult::ok)
			.orElse(ApiResult.fail(ApiCode.NOT_FOUND));
	}

	@ApiOperation("员工组商品范围-保存")
	@PostMapping("/save")
	public ApiResult<Long> save(@RequestBody @Validated SysEmployeeGroupItemSaveHeadVO saveVO) {
		return ApiResult.ok(sysEmployeeGroupItemService.save(saveVO));
	}

	@ApiOperation("员工组商品范围-删除")
	@PostMapping("/delete")
	public ApiResult<Object> delete(@RequestBody List<Long> ids) {
		sysEmployeeGroupItemService.deleteByIds(ids);
		return ApiResult.ok();
	}

}
