package com.elitescloud.cloudt.groupitem;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;

import com.elitescloud.cloudt.system.dto.SysEmployeeGroupItemDTO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemPageParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemPageRespVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemRespVO;
import com.elitescloud.cloudt.system.model.entity.SysEmployeeGroupItemDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import org.springframework.transaction.annotation.Transactional;
import java.util.List;
import java.util.Optional;

/**
 * @author nc
 * @since 2025-09-09
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SysEmployeeGroupItemDomainServiceImpl implements SysEmployeeGroupItemDomainService{

	private final SysEmployeeGroupItemRepo sysEmployeeGroupItemRepo;
	private final SysEmployeeGroupItemRepoProc sysEmployeeGroupItemRepoProc;

	@Override
	public PagingVO<SysEmployeeGroupItemPageRespVO> queryList(SysEmployeeGroupItemPageParamVO paramVO) {
		long count = sysEmployeeGroupItemRepoProc.countBy(paramVO);
		if (count > 0) {
			var list = sysEmployeeGroupItemRepoProc.pageBy(paramVO);
			return new PagingVO<>(count, list);
		}
		return new PagingVO<>();
	}

	@Override
	public Optional<SysEmployeeGroupItemDTO> findById(Long id) {
		return sysEmployeeGroupItemRepo.findById(id).map(SysEmployeeGroupItemConvert.INSTANCE::doToDto);
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public Long save(SysEmployeeGroupItemSaveVO saveVO) {
		if (saveVO.getId() == null) {
			SysEmployeeGroupItemDO sysEmployeeGroupItemDO = SysEmployeeGroupItemConvert.INSTANCE.saveVoToDO(saveVO);
			return sysEmployeeGroupItemRepo.save(sysEmployeeGroupItemDO).getId();
		} else {
			Optional<SysEmployeeGroupItemDO> option = sysEmployeeGroupItemRepo.findById(saveVO.getId());
			if (option.isEmpty()) {
				throw new BusinessException("ID：" + saveVO.getId() + "不存在");
			}
			SysEmployeeGroupItemDO sysEmployeeGroupItemDO = option.get();
			SysEmployeeGroupItemConvert.INSTANCE.copySaveParamToDo(saveVO, sysEmployeeGroupItemDO);
			return sysEmployeeGroupItemRepo.save(sysEmployeeGroupItemDO).getId();
		}
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void deleteByIds(List<Long> ids) {
		sysEmployeeGroupItemRepoProc.deleteByIds(ids);
	}

	@Override
	public List<SysEmployeeGroupItemRespVO> findByParam(SysEmployeeGroupItemParamVO paramVO) {
		return sysEmployeeGroupItemRepoProc.findByParam(paramVO);
	}

}
