//package com.elitescloud.cloudt.log.service.impl;
//
//import co.elastic.clients.elasticsearch.ElasticsearchClient;
//import co.elastic.clients.elasticsearch._types.SortOptions;
//import co.elastic.clients.elasticsearch._types.SortOrder;
//import co.elastic.clients.elasticsearch._types.query_dsl.*;
//import co.elastic.clients.elasticsearch.core.DeleteResponse;
//import co.elastic.clients.elasticsearch.core.SearchRequest;
//import co.elastic.clients.elasticsearch.core.search.Hit;
//import co.elastic.clients.json.JsonData;
//import co.elastic.clients.json.jackson.JacksonJsonpMapper;
//import co.elastic.clients.transport.ElasticsearchTransport;
//import co.elastic.clients.transport.rest_client.RestClientTransport;
//import com.elitescloud.boot.log.model.entity.AccessLogEntity;
//import com.elitescloud.cloudt.common.base.ApiResult;
//import com.elitescloud.cloudt.common.base.PagingVO;
//import com.elitescloud.cloudt.log.model.document.OperationLogDocument;
//import com.elitescloud.cloudt.log.model.vo.param.OperationLogQueryParam;
//import com.elitescloud.cloudt.log.model.vo.resp.OperationLogPageRespVO;
//import com.elitescloud.cloudt.log.service.OperationLogService;
//import com.elitescloud.cloudt.system.config.SystemProperties;
//import com.fasterxml.jackson.databind.ObjectMapper;
//import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
//import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
//import lombok.extern.log4j.Log4j2;
//import org.apache.commons.lang3.StringUtils;
//import org.apache.http.HttpHost;
//import org.apache.http.auth.AuthScope;
//import org.apache.http.auth.UsernamePasswordCredentials;
//import org.apache.http.impl.client.BasicCredentialsProvider;
//import org.elasticsearch.client.RestClient;
//import org.elasticsearch.index.query.BoolQueryBuilder;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
//import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
//import org.springframework.stereotype.Service;
//
//import java.io.IOException;
//import java.text.SimpleDateFormat;
//import java.time.Instant;
//import java.time.LocalDateTime;
//import java.time.LocalTime;
//import java.time.ZoneOffset;
//import java.time.format.DateTimeFormatter;
//import java.util.ArrayList;
//import java.util.Date;
//import java.util.List;
//import java.util.TimeZone;
//import java.util.stream.Collectors;
//import java.util.stream.Stream;
//
///**
// * @author James.Huang
// * @version 2022.1
// * @date 2023/6/30 16:03
// * @Description:
// */
//@Service
//@Log4j2
//public class OperationLogServiceImpl implements OperationLogService {
//
//    private static final String PRE_INDEX_NAME = "operation-log";
//
//    private String indexPrefix="operation-log-";
//
//    private static final DateTimeFormatter FORMATTER_INDEX = DateTimeFormatter.ofPattern("yyyy.MM.dd");
//
//    private static final DateTimeFormatter formatter_query = DateTimeFormatter.ofPattern("yyyy.MM.dd");
//
//    @Autowired
//    private SystemProperties systemProperties;
//
//    private ElasticsearchClient elasticsearchClient;
//    private ObjectMapper objectMapper;
//
//    @Override
//    public ApiResult<PagingVO<OperationLogPageRespVO>> search(OperationLogQueryParam queryParam) {
//        if(elasticsearchClient==null){
//            testBefore();
//        }
//        DateTimeFormatter pattern=DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
//        DateTimeFormatter simplePattern=DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//        String index_name="";
//        try{
//            if (queryParam.getStartTime() == null && queryParam.getEndTime() == null) {
//                index_name=convertIndex(LocalDateTime.now());
//            }
//
//            List<Query> queryList = new ArrayList<>();
//
//            if(queryParam.getStartTime()!=null&&queryParam.getEndTime()!=null){
//                String startTimeStr=queryParam.getStartTime().format(simplePattern);
//                String endTimeStr=queryParam.getEndTime().format(simplePattern);
////                LocalDateTime startTime= LocalDateTime.ofInstant(startInstant, ZoneOffset.UTC);
////                Instant endInstant = Instant.parse(queryParam.getEndTime().format(pattern));
////                LocalDateTime endTime= LocalDateTime.ofInstant(endInstant, ZoneOffset.UTC);
//                Query query = Query.of(q -> q.range(r -> r.
//                        field("@timestamp")
//                        .gte(JsonData.of(localToUDC(startTimeStr)))
//                        .lt(JsonData.of(localToUDC(endTimeStr)))));
//
//
//                queryList.add(query);
//            }
//            if(StringUtils.isNotBlank(queryParam.getSysModel())){
//                Query query = Query.of(q -> q.term(r -> r.
//                        field("sysModel.keyword")
//                        .value(value -> value.stringValue(queryParam.getSysModel()))));
//                queryList.add(query);
//            }
//            if(StringUtils.isNotBlank(queryParam.getOperationType())){
//                Query query = Query.of(q -> q.term(r -> r.
//                        field("operationType.keyword")
//                        .value(value -> value.stringValue(queryParam.getOperationType()))));
//                queryList.add(query);
//            }
//            if(StringUtils.isNotBlank(queryParam.getOperationUser())){
//                Query query = Query.of(q -> q.term(r -> r.
//                        field("operationUser.keyword")
//                        .value(value -> value.stringValue(queryParam.getOperationUser()))));
//                queryList.add(query);
//            }
//            if(StringUtils.isNotBlank(queryParam.getOperationUrl())){
//                Query query = Query.of(q -> q.term(r -> r.
//                        field("operationUrl")
//                        .value(value -> value.stringValue(queryParam.getOperationUrl()))));
//                queryList.add(query);
//            }
//            if(StringUtils.isNotBlank(queryParam.getOperationStatus())){
//                Query query = Query.of(q -> q.term(r -> r.
//                        field("operationStatus.keyword")
//                        .value(value -> value.stringValue(queryParam.getOperationStatus()))));
//                queryList.add(query);
//            }
//
//            Integer startIndex=queryParam.getCurrent()*queryParam.getSize();
//            Integer querySize=(queryParam.getCurrent()+1)*queryParam.getSize();
////            System.out.println("startIndex==="+startIndex+" querySize==="+querySize);
//
////            String[] finalIndex_name = getIndexArray(queryParam.getStartTime(),queryParam.getEndTime());
//
//            List<String> indexList=getIndexList(queryParam.getStartTime(),queryParam.getEndTime());
//            if(indexList==null || indexList.isEmpty()){
//                return ApiResult.fail("没有对应的索引");
//            }
//
//            SearchRequest searchRequest = SearchRequest.of(builder ->
//                    builder.index(indexList)
//                            .ignoreUnavailable(true)
//                            .query(q -> q.bool(b -> b.must(queryList)))
//                            .sort(SortOptions.of(sort -> sort.field(field -> field.field("operationTime").order(SortOrder.Desc))))
//                            .from(startIndex)
//                            .size(querySize)
//            );
//            var resp = elasticsearchClient.search(searchRequest, OperationLogDocument.class);
//            var hits = resp.hits();
//            System.out.println("hits.total==="+hits.total());
//
//            var operDocList=hits.hits().stream().map(
//                    hit->{
//                        OperationLogDocument op=hit.source();
//                        op.setId(hit.id());
//                        OperationLogPageRespVO olVO=new OperationLogPageRespVO();
//                        olVO.setId(op.getId());
//                        olVO.setTriggerTerminal(op.getTriggerTerminal());
//                        olVO.setSysModel(op.getSysModel());
//                        olVO.setOperationType(op.getOperationType());
//                        olVO.setOperationUser(op.getOperationUser());
//                        olVO.setOperationUrl(op.getOperationUrl());
//                        olVO.setOperationTime(op.getOperationTime());
//                        olVO.setOperationDateTime(op.getOperationDateTime());
//                        olVO.setOperationIp(op.getOperationIp());
//                        olVO.setOperationStatus(op.getOperationStatus());
//                        olVO.setRequestParam(op.getRequestParam());
//                        olVO.setResponseParam(op.getResponseParam());
//                        olVO.setLogId(op.getLogId());
//                        olVO.setRequestMethod(op.getRequestMethod());
//                        olVO.setExceptionDesc(op.getExceptionDesc());
//
//                        return olVO;
//
//                    }
//            ).collect(Collectors.toList());
//
//
//            Long valueTotal=0l;
//            if(hits.total()!=null&&hits.total().value()!=0l){
//                valueTotal=hits.total().value();
//            }
//
//            return ApiResult.ok(PagingVO.<OperationLogPageRespVO>builder().total(valueTotal).records(operDocList).build());
//
//        }catch (Exception e){
//            e.printStackTrace();
//        }
//
//        return null;
//    }
//
//    public String localToUDC(String localTime){
//        SimpleDateFormat format=new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
//        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        String utcStr="";
//        try{
//           Date day=sdf.parse(localTime);
//           format.setTimeZone(TimeZone.getTimeZone("UTC"));
//            utcStr=format.format(day);
//        }catch (Exception e){
//           e.printStackTrace();
//        }
//        return utcStr;
//    }
//
//    @Override
//    public ApiResult<?>  deleteBatch(OperationLogQueryParam queryParam) {
//        if(elasticsearchClient==null){
//            testBefore();
//        }
////        String index_name=convertIndex(LocalDateTime.now());
//        List<String> indexList=getIndexList(queryParam.getStartTime(),queryParam.getEndTime());
//        if(indexList==null || indexList.isEmpty()){
//            return ApiResult.fail("没有对应的索引");
//        }
//
//        for(String indexName:indexList){
//            try{
//                for(String id:queryParam.getIdList()){
//                    DeleteResponse deleteResponse = elasticsearchClient.delete(deleteRequest ->
//                            deleteRequest.index(indexName).id(id)
//                    );
////                    System.out.println(deleteResponse.result());
//                }
//
//            }catch (Exception e){
//                log.error("批量删除操作日志出错",e);
//            }
//        }
//
//        return ApiResult.ok();
//
//    }
//
////    private QueryBuilders buildQueryBuilder(OperationLogQueryParam queryParam){
////
////
////    }
//
//    private String convertIndex(LocalDateTime date) {
//        return indexPrefix + date.format(FORMATTER_INDEX);
//    }
//
//    private List<String> getIndexList(LocalDateTime startTime, LocalDateTime endTime){
//
//        List<String> indexList=new ArrayList<>();
//        if (startTime == null && endTime == null) {
//            indexList.add(convertIndex(LocalDateTime.now()));
//            return indexList;
//        }
//
//        LocalDateTime now = LocalDateTime.now();
//        LocalDateTime end = null;
//        if (endTime == null || endTime.isAfter(now)) {
//            end = now.with(LocalTime.MAX);
//        } else {
//            end = endTime.with(LocalTime.MAX);
//        }
//        List<String> indexNames = Stream.iterate(startTime == null ? LocalDateTime.now() : startTime, end::isAfter, f -> f.plusDays(1))
//                .map(this::convertIndex)
//                .filter(this::existsIndex)
//                .collect(Collectors.toList());
//        if (indexNames.size() == 0) {
//            // 没有符合条件的索引
//            log.info("没有符合条件的索引存在");
//            return null;
//        }
//
//        return indexNames;
//
//    }
//
//    private boolean existsIndex(String indexName) {
//        try {
//            var result = elasticsearchClient.indices().exists(builder -> builder.index(indexName)).value();
//            return result;
//        } catch (IOException e) {
//            return false;
//        }
////        return true;
//    }
//
//    public void testBefore() {
//
//        String esAddress=systemProperties.getEsAddress();
//        //"http://es-cn-5yd36byvb000v39rk.public.elasticsearch.aliyuncs.com:9200"
//        HttpHost[] httpHosts = new HttpHost[]{HttpHost.create(esAddress)};
//        var client = RestClient.builder(httpHosts)
////                .setHttpClientConfigCallback(httpClientBuilder -> {
////                    // 设置账号密码
////                    var credentialsProvider = new BasicCredentialsProvider();
////                    credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials("elastic", "Abcd1234"));
////                    httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
////                    return httpClientBuilder;
////                })
//                .build();
//
//        objectMapper = Jackson2ObjectMapperBuilder.json()
//                .simpleDateFormat("uuuu-MM-dd HH:mm:ss")
//                .serializerByType(LocalDateTime.class, new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss")))
//                .deserializerByType(LocalDateTime.class, new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss")))
//                .build();
//        JacksonJsonpMapper jsonpMapper = new JacksonJsonpMapper(objectMapper);
//
//        ElasticsearchTransport transport = new RestClientTransport(client, jsonpMapper);
//        elasticsearchClient = new ElasticsearchClient(transport);
//    }
//
//}
