package com.elitescloud.cloudt.spi.test.controller;

import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.spi.test.UserMngSpiTestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/11/11
 */
@RestController
public class MyTestController {

    @Autowired(required = false)
    private UserMngSpiTestService userMngSpiService;

    @Autowired
    private RedisUtils redisUtils;

    @GetMapping(value = "/test/spi/onUserCreate")
    public ApiResult<Boolean> onUserCreate() {

        userMngSpiService.onUserCreate("张三");

        return ApiResult.ok(true);
    }

    @GetMapping(value = "/test/redis")
    public ApiResult<Double> testRedis() {
        float v = 5.2f;

        redisUtils.hset("wangs_hincr", "my", v);

        float inc = 2.0f * -1;
        var val = redisUtils.hincr("wangs_hincr", "my", inc);
        return ApiResult.ok(val);
    }
}
