package com.elitescloud.cloudt.system.common;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 13:47
 * @Description:
 */
@Getter
public enum AuthMethod {
    /**
     * 认证方式
     */
    AUTH_METHOD_INHERIT("INHERIT", "Inherit auth from parent"),
    AUTH_METHOD_NO_AUTH("NO_AUTH", "No Auth"),
    AUTH_METHOD_BASIC_AUTH("BASIC_AUTH", "Basic Auth"),
    AUTH_METHOD_TOKEN("TOKEN", "Bearer Token"),
    AUTH_METHOD_JWT("JWT", "JWT Bearer"),
    AUTH_METHOD_OAUTH_V1("OAUTH_1.0", "OAuth 1.0"),
    AUTH_METHOD_OAUTH_V2("OAUTH_2.0", "OAuth 2.0"),
    AUTH_METHOD_AWS("AWS", "AWS Signature"),
    AUTH_METHOD_IP("IP", "IP Whitelist"),
    ;

    private final String code;
    private final String desc;

    AuthMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull(code)) return null;
        for (AuthMethod status : AuthMethod.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return "";
    }
}
