package com.elitescloud.cloudt.system.common;

import java.util.stream.Stream;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 17:32
 * @Description:
 */
public enum TrackType implements TrackDef {

    LOG_SYSTEM("系统日志"),
    LOG_AUDIT("审计日志"),
    LOG_INFINITY_INVOKE("接口日志(主动)"),
    LOG_INFINITY_PASSIVE("接口日志(被动)"),
    LOG_TRACK("埋点日志"),
    INBOX_INFO("消息"),
    INBOX_TODO("待办"),
    INBOX_WARN("告警"),
    EVICT_LOGIN("取消登录"),
    EVICT_RESET("用户重置");

    private final String name;

    private TrackType(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.name();
    }

    public static Stream<TrackType> getStoreTypes() {
        return Stream.of(values()).filter((v) -> {
            return v.getStoreName() != null;
        });
    }

    public String getName() {
        return this.name;
    }
}
