package com.elitescloud.cloudt.system.controller.common;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.Terminal;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 通用常量接口.
 *
 * @author Kaiser（wang shao）
 * 2022/10/21
 */
@Api(tags = "通用常量接口")
@RestController
@RequestMapping(value = "/common/constant", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class CommonConstantController {

    /**
     * 性别
     *
     * @return 性别
     */
    @ApiOperation(value = "性别")
    @GetMapping(value = "/gender")
    public ApiResult<List<CodeNameParam>> getGenders() {
        var genders = Gender.all().stream()
                .map(t -> new CodeNameParam(t.getValue(), t.getDescription()))
                .collect(Collectors.toList());
        return ApiResult.ok(genders);
    }

    /**
     * 用户终端
     *
     * @return 性别
     */
    @ApiOperation(value = "用户终端")
    @GetMapping(value = "/terminal")
    public ApiResult<List<CodeNameParam>> getTerminals() {
        var genders = Arrays.stream(Terminal.values())
                .map(t -> new CodeNameParam(t.name(), t.getDescription()))
                .collect(Collectors.toList());
        return ApiResult.ok(genders);
    }
}
