package com.elitescloud.cloudt.system.controller.devops;

import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.core.support.common.param.SysVersionUploadVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.devops.ProjectVersionPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ProjectVersionPageRespVO;
import com.elitescloud.cloudt.system.service.ProjectVersionMngService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

import java.util.Set;

/**
 * 项目版本信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/2
 */
@Api(tags = "项目版本信息")
@ApiIgnore
@RestController
@RequestMapping(value = "/devops/version", produces = MediaType.APPLICATION_JSON_VALUE)
public class ProjectVersionController {

    static {
        InterceptUri.addAllowUri(Set.of("/devops/version/report"));
    }

    private ProjectVersionMngService mngService;

    @PostMapping(value = "/report")
    public ApiResult<Boolean> report(@RequestBody SysVersionUploadVO versionUploadVO) {
        return mngService.upload(versionUploadVO);
    }

    @PostMapping(value = "/page")
    ApiResult<PagingVO<ProjectVersionPageRespVO>> pageMng(@RequestBody ProjectVersionPageQueryVO queryVO) {
        return mngService.pageMng(queryVO);
    }

    @Autowired
    public void setMngService(ProjectVersionMngService mngService) {
        this.mngService = mngService;
    }
}
