package com.elitescloud.cloudt.system.controller.mng.common;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessObjectTreeNodeRespVO;
import com.elitescloud.cloudt.system.service.BusinessObjectMngService;
import com.elitescloud.cloudt.system.service.BusinessObjectQueryService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 业务对象相关通用接口.
 *
 * @author Kaiser（wang shao）
 * 2024/3/19
 */
@Api(tags = "通用业务对象接口")
@RestController
@RequestMapping(value = "/mng/common/businessObject", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class CommonBusinessObjectController {

    private final BusinessObjectMngService mngService;
    private final BusinessObjectQueryService queryService;

    public CommonBusinessObjectController(BusinessObjectMngService mngService, BusinessObjectQueryService queryService) {
        this.mngService = mngService;
        this.queryService = queryService;
    }

    @ApiOperation(value = "获取业务对象树")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tree", value = "是否返回树状", dataType = "boolean", defaultValue = "true"),
            @ApiImplicitParam(name = "withApp", value = "是否返回应用", dataType = "boolean", defaultValue = "true"),
            @ApiImplicitParam(name = "withOperation", value = "是否返回操作", dataType = "boolean", defaultValue = "true"),
            @ApiImplicitParam(name = "withRef", value = "是否显示关联的", dataType = "boolean", defaultValue = "false"),
            @ApiImplicitParam(name = "permissionOnly", value = "是否仅返回支持权限的", dataType = "boolean", defaultValue = "false"),
    })
    @GetMapping(value = "/tree")
    public ApiResult<List<BusinessObjectTreeNodeRespVO>> businessObjectTree(@RequestParam(name = "tree", required = false, defaultValue = "true") Boolean tree,
                                                                            @RequestParam(name = "withApp", required = false, defaultValue = "true") Boolean withApp,
                                                                            @RequestParam(name = "withOperation", required = false, defaultValue = "true") Boolean withOperation,
                                                                            @RequestParam(name = "withRef", required = false, defaultValue = "false") Boolean withRef,
                                                                            @RequestParam(name = "permissionOnly", required = false, defaultValue = "false") Boolean permissionOnly) {
        return queryService.businessObjectTree(tree, withApp, withOperation, withRef, permissionOnly);
    }
}
