package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformCurrencyDO;
import com.elitescloud.cloudt.platform.model.vo.extend.query.CurrencyPageQueryVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.CurrencyPageRespVO;
import com.elitescloud.cloudt.system.service.CurrencyMngService;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 货币管理.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/13
 */
@Api(tags = "货币管理")
@RestController
@RequestMapping(value = "/mng/currency", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@BusinessObject(businessType = BusinessObjectConstant.SYS_CURRENCY, businessDoClass = SysPlatformCurrencyDO.class)
public class CurrencyController {

    private final CurrencyMngService service;

    public CurrencyController(CurrencyMngService service) {
        this.service = service;
    }

    /**
     * 分页查询货币
     *
     * @param queryVO 查询参数
     * @return 货币列表
     */
    @PostMapping(value = "/q")
    @ApiOperation(value = "分页查询货币")
    @ApiOperationSupport(order = 1)
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "分页查询货币", dataPermissionEnabled = true
    )
    public ApiResult<PagingVO<CurrencyPageRespVO>> page(@RequestBody CurrencyPageQueryVO queryVO) {
        return service.page(queryVO);
    }

    /**
     * 切换启用禁用
     *
     * @param id 货币ID
     * @return 切换结果
     */
    @PatchMapping(value = "/switch/{id}/enabled")
    @ApiOperation(value = "切换启用禁用")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "id", value = "货币ID", required = true)
    @BusinessObjectOperation(operationType = OperationTypeEnum.UPDATE, operationDescription = "切换启用禁用"
            , logEnabled = true, resultJsonEnabled = true, argsJsonEnabled = true)
    public ApiResult<Long> switchEnabled(@PathVariable("id") Long id) {
        return service.execSwitchEnabled(id);
    }
}
