package com.elitescloud.cloudt.system.controller.mng.position;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.model.entity.SysPositionDO;
import com.elitescloud.cloudt.system.model.vo.query.position.*;
import com.elitescloud.cloudt.system.service.SysPositionService;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : chen.niu
 * @description : 岗位管理
 * @date : 2024-05-13 16:13
 */
@RestController
@RequestMapping("/positions")
@Api(tags = "岗位管理")
@BusinessObject(businessType = BusinessObjectConstant.SYS_POSITION)
public class SysPositionController {


    private final SysPositionService sysPositionService;

    public SysPositionController(SysPositionService sysPositionService) {
        this.sysPositionService = sysPositionService;
    }

    @PostMapping("/getAllPositions")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT,
            operationDescription = "岗位查询")
    public ApiResult<List<SysPositionVo>> getAllPositions(@RequestBody SysPositionQueryVo sysPositionVo) {
        return sysPositionService.getAllPositions(sysPositionVo);
    }
    @GetMapping("/findOrgsByPosition/{positionCode}")
    public ApiResult<List<OrgVo>> findOrgsByPosition(@PathVariable String positionCode) {
        return ApiResult.ok(sysPositionService.findOrgsByPosition(positionCode));
    }
    @GetMapping("/findRolesByPosition/{positionCode}")
    public ApiResult<List<RoleVo>> findRolesByPosition(@PathVariable String positionCode) {
        return ApiResult.ok(sysPositionService.findRolesByPosition(positionCode));
    }
    @GetMapping("/getPositionByCode/{positionCode}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT,
            operationDescription = "岗位编码查询")
    public ApiResult<SysPositionVo> getPositionByCode(@PathVariable("positionCode") String positionCode) {
            return sysPositionService.getPositionByCode(positionCode);
    }
    @GetMapping("/getPositionById/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT,
            operationDescription = "岗位ID查询")
    public ApiResult<SysPositionVo> getPositionById(@PathVariable("id") Long id) {
        return sysPositionService.getPositionById(id);
    }

    @PostMapping
    @GetMapping("/createPosition")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ADD,
            operationDescription = "岗位创建")
    public ApiResult<Long> createPosition(@RequestBody SysPositionSaveVo position) {
        return sysPositionService.createPosition(position);
    }

    @PutMapping("/updatePosition/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.UPDATE,
            operationDescription = "岗位更新")
    public ApiResult<Boolean> updatePosition(@PathVariable("id") Long id, @RequestBody SysPositionSaveVo position) {
       return sysPositionService.updatePosition(id, position);
    }

    @DeleteMapping("/{id}")
    @BusinessObjectOperation(operationType = OperationTypeEnum.DELETE,
            operationDescription = "岗位ID删除")
    public ApiResult<Void> deletePosition(@PathVariable("id") Long id) {
        sysPositionService.deletePosition(id);
        return ApiResult.ok();
    }
}