package com.elitescloud.cloudt.system.controller.mng.sys;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.sys.PwdStrategyConfigRespVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.PwdStrategySaveVO;
import com.elitescloud.cloudt.system.service.SystemMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 系统管理.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/9
 */
@Api(tags = "系统管理")
@RestController
@RequestMapping(value = "/mng/system", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class SystemMngController {

    private SystemMngService service;

    /**
     * 获取密码安全策略配置
     *
     * @return 密码安全策略配置
     */
    @ApiOperation(value = "获取密码安全策略配置")
    @ApiOperationSupport(order = 1)
    @GetMapping(value = "/pwdStrategy")
    public ApiResult<PwdStrategyConfigRespVO> getPwdStrategy() {
        return service.getPwdStrategy();
    }

    /**
     * 获取密码安全策略配置
     *
     * @return 密码安全策略配置
     */
    @ApiOperation(value = "获取默认的密码安全策略")
    @ApiOperationSupport(order = 2)
    @GetMapping(value = "/pwdStrategy/default")
    public ApiResult<PwdStrategyConfigRespVO> getDefault() {
        return service.getDefaultPwdStrategy();
    }

    /**
     * 保存密码安全策略配置
     *
     * @param saveVO 密码安全策略配置
     * @return 保存结果
     */
    @ApiOperation(value = "保存密码安全策略配置")
    @ApiOperationSupport(order = 3)
    @PostMapping(value = "/pwdStrategy")
    public ApiResult<Boolean> savePwdStrategy(@Valid @RequestBody List<PwdStrategySaveVO> saveVO) {
        return service.save(saveVO);
    }

    @Autowired
    public void setService(SystemMngService service) {
        this.service = service;
    }
}
