package com.elitescloud.cloudt.system.controller.test;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaDetailRespVO;
import com.elitescloud.cloudt.system.service.impl.InfinityRestClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * @Auther: Mark
 * @Date: 2024/12/24 11:44
 * @Description:
 */
@Slf4j
@Service
public class SeeyonServiceImpl implements SeeyonService {

    private static final String AREA_DETAIL = "Area_Detail";
    @Autowired
    @Lazy
    private InfinityRestClient restClient;

    @Override
    public ApiResult<AreaDetailRespVO> get(Long id) {
        log.info("区域详情入参id:{}", id);
        Map<String, String> pathParam = new HashMap<>();
        pathParam.put("id", String.valueOf(id));

        HttpServletRequest httpServletRequest = HttpServletUtil.currentRequest();
        String auth = httpServletRequest.getHeader("Authorization");
        MultiValueMap<String, String> headerParam = new LinkedMultiValueMap<>();
        headerParam.add("Authorization", auth);
        var result = restClient.exchange(AREA_DETAIL, (builder) -> {
            builder.pathParam(pathParam);
            builder.headerParam(headerParam);
            return builder.build();
        });
        String entityJsonStr = result.toEntity();
        ApiResult data = JSONUtil.toBean(entityJsonStr, ApiResult.class);
        log.info("区域详情结果：{}", data);
        return data;
    }
}
