package com.elitescloud.cloudt.system.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.dto.req.DataRelationQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.DataRelationRespDTO;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstQueryBO;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstValueBO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonDataRelationQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.datarelation.DataRelationInstEditQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataRelationRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationConfigRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationInstEditRespVO;
import com.elitescloud.cloudt.system.model.vo.save.datarelation.DataRelationSaveVO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataRelationCategoryDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataRelationDO;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/15
 */
@Mapper(config = BaseMapperConfig.class)
public interface DataRelationConvert {
    DataRelationConvert INSTANCE = Mappers.getMapper(DataRelationConvert.class);

    void copy(DataRelationSaveVO saveVO, @MappingTarget SysDataRelationDO relationDO);

    DataRelationEditRespVO do2EditRespVO(SysDataRelationDO relationDO);

    DataRelationEditRespVO.Cat do2EditRespVO(SysDataRelationCategoryDO categoryDO);

    DataRelationConfigRespVO do2ConfigRespVO(SysDataRelationDO relationDO);

    DataRelationConfigRespVO.Cat do2ConfigRespVO(SysDataRelationCategoryDO categoryDO);

    DataRelationInstQueryBO queryVo2Bo(DataRelationInstEditQueryVO valueBO);

    List<DataRelationInstEditRespVO> bo2RespVo(List<DataRelationInstValueBO> valueBO);

    DataRelationInstQueryBO queryDto2Bo(DataRelationQueryDTO queryDTO);

    DataRelationRespDTO valueBo2Dto(DataRelationInstValueBO valueBO);

    DataRelationInstQueryBO queryVo2Bo(CommonDataRelationQueryVO queryVO);

    CommonDataRelationRespVO valueBo2Vo(DataRelationInstValueBO valueBO);
}
