package com.elitescloud.cloudt.system.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 业务操作的参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/20
 */
@Getter
@Setter
public class BusinessOperationParamBO implements Serializable {
    private static final long serialVersionUID = 7730449743560480202L;

    /**
     * ID
     */
    private Long id;

    /**
     * 业务对象操作编码
     */
    private String businessOperationCode;

    /**
     * 字段名称
     */
    private String fieldName;

    /**
     * 字段描述
     */
    private String fieldDescription;

    /**
     * 字段类型
     */
    private String fieldType;

    /**
     * java类型
     */
    private String fieldJavaType;

    /**
     * 是否为请求参数
     */
    private Boolean request;

    /**
     * 是否有依赖
     */
    private Boolean ref;

    /**
     * 依赖值
     */
    private String refValue;

    /**
     * 参数深度
     */
    private Integer depth;

    /**
     * 参数路径
     */
    private String paramPath;

    /**
     * 是否是ApiResult的参数
     */
    private Boolean apiResult;

    /**
     * 是否是PagingVO的参数
     */
    private Boolean pagingResult;
    @ApiModelProperty(value = "是否过滤权限字段")
    private Boolean fieldPermissionFilter;
    /**
     * 参数位置
     */
    private String paramIn;

    /**
     * 是否必须
     */
    private Boolean required;

    /**
     * 是否过期
     */
    private Boolean deprecated;

    /**
     * 是否是单值
     */
    private Boolean single;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 下级参数
     */
    private List<BusinessOperationParamBO> childrenParams;

    public boolean isApiResultData() {
        return Boolean.TRUE.equals(this.apiResult) && "data".equals(this.fieldName);
    }
}
