package com.elitescloud.cloudt.system.model.entity;

import java.io.Serializable;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
    import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * <p>
 * 员工组商品范围
 * </p>
 *
 * @author nc
 * @since 2025-09-09
 */
@Entity
@Table(name = "sys_employee_group_item")
@org.hibernate.annotations.Table(appliesTo = "sys_employee_group_item", comment = "员工组商品范围")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "员工组商品范围", description = "员工组商品范围")
@Where(clause = "delete_flag = 0")
public class SysEmployeeGroupItemDO extends BaseModel {
    @ApiModelProperty("员工组ID")
    @Comment("员工组ID")
    @Column()
    private Long employeeGroupId;

    @ApiModelProperty("范围类型")
    @Comment("范围类型")
    @Column()
    private String itemScopeType;

    @ApiModelProperty("编码")
    @Comment("编码")
    @Column()
    private String itemScopeCode;

    @ApiModelProperty("名称")
    @Comment("名称")
    @Column()
    private String itemScopeName;

    @ApiModelProperty("别名")
    @Comment("别名")
    @Column()
    private String itemScopeNameAlias;

    @ApiModelProperty("父级节点编码")
    @Comment("父级节点编码")
    @Column()
    private String itemScopeParentCode;

    @ApiModelProperty("父级节点编码")
    @Comment("父级节点编码")
    @Column()
    private String itemScopeParentName;

    @ApiModelProperty("描述")
    @Comment("描述")
    @Column()
    private String itemScopeDescription;

    @ApiModelProperty("状态")
    @Comment("状态")
    @Column()
    private String itemScopeStatus;

}
