package com.elitescloud.cloudt.system.model.entity;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/9/8 11:41
 */

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 页面字段配置;
 * @author : http://www.chiner.pro
 * @date : 2023-9-8
 */
@ApiModel(value = "页面字段配置",description = "")
@Comment("页面字段配置")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
@Table(name="sys_page_field_config")
@Entity
public class SysPageFieldConfigDO extends BaseModel  implements Serializable,Cloneable{

    /** 所属应用 */
    @ApiModelProperty(name = "所属应用",notes = "")
    private String appCode ;
    /** 所属应用名称 */
    @ApiModelProperty(name = "所属应用名称",notes = "")
    private String appName ;
    /** 配置名称 */
    @ApiModelProperty(name = "配置名称",notes = "")
    private String configName ;
    /** 配置编码 */
    @ApiModelProperty(name = "配置编码",notes = "")
    private String configCode ;
    /** 备注 */
    @ApiModelProperty(name = "备注",notes = "")
    private String remark ;
    /** 是否可用 */
    @ApiModelProperty(name = "是否可用",notes = "")
    private Boolean enabled ;
}
