package com.elitescloud.cloudt.system.model.entity;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:33
 * @Description:
 */
@Data
@ApiModel("任务实例 - 删除参数")
public class TrackDocDeleteParamVO {
    @ApiModelProperty(value = "日志链路ID")
    private List<String> traceIds;

    @ApiModelProperty(value = "日期")
    private LocalDateTime beforeTime;

    /**
     * 所有条件均为空
     */
    public boolean isEmpty() {
        return CollUtil.isEmpty(traceIds) && ObjectUtil.isNull(beforeTime);
    }
}
