package com.elitescloud.cloudt.system.model.vo.query.devops;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 缓存方法数据查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/12
 */
@Getter
@Setter
@ApiModel(description = "缓存方法数据查询参数")
public class CacheMethodDataQueryVO implements Serializable {
    private static final long serialVersionUID = -6136095040988663111L;

    @NotBlank(message = "服务实例ID为空")
    @ApiModelProperty(value = "服务实例ID", required = true)
    private String serviceId;

    @NotBlank(message = "缓存服务标识为空")
    @ApiModelProperty(value = "缓存服务标识", required = true)
    private String cacheServiceKey;

    @NotBlank(message = "缓存方法为空")
    @ApiModelProperty(value = "缓存方法", required = true)
    private String method;

    @ApiModelProperty(value = "入参")
    private Object[] params;

    @ApiModelProperty(value = "租户编码")
    private String tenantCode;
}
