package com.elitescloud.cloudt.system.model.vo.query.user;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 用户列表查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/19
 */
@Data
@ApiModel(description = "用户列表查询参数")
public class UserListQueryVO implements Serializable {
    private static final long serialVersionUID = -1041822867487043092L;

    @ApiModelProperty(value = "根据姓名模糊查询", position = 1)
    private String fullNameLike;

    @ApiModelProperty(value = "根据登录号模糊查询", position = 2)
    private String usernameLike;

    @ApiModelProperty(value = "根据姓名或登录号模糊查询", position = 3)
    private String fullNameOrUsernameLike;
}
