package com.elitescloud.cloudt.system.model.vo.resp.common;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/22
 */
@Getter
@Setter
@ApiModel(description = "数据关系结果")
public class CommonDataRelationRespVO implements Serializable {
    private static final long serialVersionUID = -6336651206357429123L;

    /**
     * 数据关系编码
     */
    @ApiModelProperty(value = "数据关系编码", position = 1)
    private String drCode;

    /**
     * 分类编码
     */
    @ApiModelProperty(value = "分类编码", position = 2)
    private String catCode;

    /**
     * 主数据的标识
     */
    @ApiModelProperty(value = "主数据的标识", position = 3)
    private String dataKey;

    /**
     * 主数据的检索属性
     */
    @ApiModelProperty(value = "主数据的检索属性", position = 4)
    private String dataAttribute;

    /**
     * 主数据的扩展信息
     */
    @ApiModelProperty(value = "主数据的扩展信息", position = 5)
    private Map<String, String> dataExt;

    /**
     * 关联数据的标识
     */
    @ApiModelProperty(value = "关联数据的标识", position = 6)
    private String refDataKey;

    /**
     * 关联数据的检索属性
     */
    @ApiModelProperty(value = "关联数据的检索属性", position = 7)
    private String refDataAttribute;

    /**
     * 关联数据的扩展信息
     */
    @ApiModelProperty(value = "关联数据的扩展信息", position = 8)
    private Map<String, String> refDataExt;
}
