package com.elitescloud.cloudt.system.model.vo.resp.devops;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 服务实例信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/8
 */
@Getter
@Setter
@ApiModel(description = "服务实例信息")
public class ServiceInstanceThreadPoolsRespVO implements Serializable {
    private static final long serialVersionUID = -7745861876378055716L;

    /**
     * 线程池名称
     */
    @ApiModelProperty(value = "线程池名称")
    private String threadPoolName;

    /**
     * 核心线程数量
     */
    @ApiModelProperty(value = "核心线程数量")
    private Integer coreSize;

    /**
     * 最大数量
     */
    @ApiModelProperty(value = "最大数量")
    private Integer maxSize;

    /**
     * 当前线程池大小
     */
    @ApiModelProperty(value = "当前线程池大小")
    private Integer currentSize;

    /**
     * 当前激活的线程数
     */
    @ApiModelProperty(value = "当前激活的线程数")
    private Integer activeCount;

    /**
     * 线程池曾达到的最大数量
     */
    @ApiModelProperty(value = "线程池曾达到的最大数量")
    private Integer largestPoolSize;

    /**
     * 已计划执行的任务数量
     */
    @ApiModelProperty(value = "已计划执行的任务数量")
    private Long taskCount;

    /**
     * 完成的任务数量
     */
    @ApiModelProperty(value = "完成的任务数量")
    private Long completedTaskCount;

    /**
     * 队列类型
     */
    @ApiModelProperty(value = "队列类型")
    private String queueType;

    /**
     * 队列大小
     */
    @ApiModelProperty(value = "队列大小")
    private Integer queueSize;

    /**
     * 队列剩余容量
     */
    @ApiModelProperty(value = "队列剩余容量")
    private Integer queueRemainingCapacity;

    /**
     * 队列当前容量
     */
    @ApiModelProperty(value = "队列当前容量")
    private Integer queueCapacity;

    /**
     * 拒绝方式类型
     */
    @ApiModelProperty(value = "拒绝方式类型")
    private String rejectHandlerType;

    /**
     * 是否允许核心线程超时
     */
    @ApiModelProperty(value = "允许核心线程超时")
    private Boolean allowCoreThreadTimeOut;

    /**
     * 保留存活时间
     * <p>
     * 单位：毫秒
     */
    @ApiModelProperty(value = "保留存活时间，单位：毫秒")
    private Long keepAliveTime;

    /**
     * 线程信息
     */
    @ApiModelProperty(value = "线程信息")
    private List<ThreadInfo> threadInfoList;


    @Getter
    @Setter
    @ApiModel(value = "ServiceInstanceThreadsRespVO_ThreadInfo", description = "栈信息")
    public static class ThreadInfo implements Serializable {
        private static final long serialVersionUID = -8813008047068630547L;

        /**
         * 线程名称
         */
        @ApiModelProperty(value = "线程名称")
        private String threadName;

        /**
         * 线程ID
         */
        @ApiModelProperty(value = "线程ID")
        private Long threadId;

        /**
         * 启动时间
         */
        @ApiModelProperty(value = "启动时间")
        private LocalDateTime startTime;

        /**
         * 堆栈信息
         */
        @ApiModelProperty(value = "堆栈信息")
        private List<String> stackStraceList;
    }
}
