package com.elitescloud.cloudt.system.model.vo.resp.devops;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 服务实例的线程信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/8
 */
@Getter
@Setter
@ApiModel(description = "服务实例的线程信息")
public class ServiceInstanceThreadsRespVO implements Serializable {
    private static final long serialVersionUID = -7745861876378055716L;

    /**
     * 线程名称
     */
    @ApiModelProperty(value = "线程名称")
    private String threadName;

    /**
     * 线程ID
     */
    @ApiModelProperty(value = "线程ID")
    private long threadId;

    /**
     * 锁名称
     */
    @ApiModelProperty(value = "锁名称")
    private String lockName;

    /**
     * 是否是守护线程
     */
    @ApiModelProperty(value = "是否是守护线程")
    private boolean daemon;

    /**
     * 是否是jvm的
     */
    @ApiModelProperty(value = "是否是jvm的")
    private boolean inNative;

    /**
     * 是否挂起
     */
    @ApiModelProperty(value = "是否挂起")
    private boolean suspended;

    /**
     * 线程状态
     */
    @ApiModelProperty(value = "线程状态")
    private Thread.State threadState;

    /**
     * 优先级
     */
    @ApiModelProperty(value = "优先级")
    private int priority;

    /**
     * 调用栈
     */
    @ApiModelProperty(value = "调用栈")
    private List<ServiceInstanceThreadsRespVO.StackTraceElement> stackTrace;


    @Getter
    @Setter
    @ApiModel(value = "ServiceInstanceThreadsRespVO_StackTraceElement", description = "栈信息")
    public static class StackTraceElement implements Serializable {
        private static final long serialVersionUID = -8813008047068630547L;

        /**
         * 类名
         */
        @ApiModelProperty(value = "类名")
        private String declaringClass;
        /**
         * 方法名
         */
        @ApiModelProperty(value = "方法名")
        private String methodName;
        /**
         * 文件名
         */
        @ApiModelProperty(value = "文件名")
        private String fileName;
        /**
         * 行号
         */
        @ApiModelProperty(value = "行号")
        private int lineNumber;
    }
}
