package com.elitescloud.cloudt.system.model.vo.resp.dpr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 数据权限参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/27
 */
@Getter
@Setter
@ApiModel(description = "数据权限参数")
public class DataPermissionParamRespVO implements Serializable {
    private static final long serialVersionUID = -2330722850886665431L;

    @ApiModelProperty(value = "ID", position = 0)
    private Long id;

    @ApiModelProperty(value = "字段名称", position = 1)
    private String fieldName;

    @ApiModelProperty(value = "字段描述", position = 2)
    private String fieldRemark;

    @ApiModelProperty(value = "是否启用", position = 3)
    private Boolean enabled;

    @ApiModelProperty(value = "是否是基础字段", position = 4)
    private Boolean based;

    @ApiModelProperty(value = "是否是系统内置字段", position = 5)
    private Boolean inner;

    @ApiModelProperty(value = "关联的业务对象", position = 11)
    private String relatedBusinessObject;

    @ApiModelProperty(value = "关联的业务对象名称", position = 12)
    private String relatedBusinessObjectName;

    @ApiModelProperty(value = "是否关联的业务对象资源", position = 13)
    private Boolean relatedResource;

    @ApiModelProperty(value = "关联字段", position = 14)
    private String relatedField;

    @ApiModelProperty(value = "关联的应用编码", position = 15)
    private String relatedAppCode;

    @ApiModelProperty(value = "关联的UDC编码", position = 16)
    private String relatedUdcCode;
}
