package com.elitescloud.cloudt.system.model.vo.resp.extend;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 13:49
 * @Description:
 */
@Data
public class OAuth2AccountVO {

    /**
     * 认证地址
     */
    private String url;

    /**
     * AppId or ClientId
     */
    private String clientId;

    /**
     * AppSecret or ClientSecret
     */
    private String clientSecret;

    @JsonIgnore
    public boolean isEmpty() {
        return StrUtil.isBlank(url) || StrUtil.isBlank(clientId) || StrUtil.isBlank(clientSecret);
    }
}
