package com.elitescloud.cloudt.system.model.vo.resp.extend;

import cn.hutool.core.util.ArrayUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderValidator;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 13:41
 * @Description:
 */
@Data
public class PageQueryParam implements Serializable {

    /**
     * 页码，1表示第一页
     *
     * @since 0.1.12-SNAPSHOT
     */
    private int current;

    /**
     * 兼容云梯的分页参数规则
     *
     * @since 0.1.12-SNAPSHOT
     */
    public int getPageNumber() {
        return current > 0 ? current - 1 : 0;
    }

    /**
     * 每页结果数
     *
     * @since 0.1.12-SNAPSHOT
     */
    private int size;

    /**
     * 排序
     *
     * @since 0.1.12-SNAPSHOT
     */
    private List<OrderItem> orders;

    @JsonIgnore
    public void setPaging(JPAQuery<?> query) {
        int curr = current > 0 ? current - 1 : 0;
        query.offset((long) curr * getSize());
        query.limit(getSize());
    }

    @JsonIgnore
    public void fillOrders(JPAQuery<?> query, EntityPathBase<?> entityPathBase) {
        if (ArrayUtil.isEmpty(getOrders())) return;
        PathBuilder orderByExpr = new PathBuilder<>(entityPathBase.getClass(), entityPathBase.getMetadata(),
                PathBuilderValidator.FIELDS);
        for (OrderItem order : getOrders()) {
            OrderSpecifier orderSpecifier = new OrderSpecifier(
                    order.isAsc() ? Order.ASC : Order.DESC, orderByExpr.get(order.getColumn())
            );
            query.orderBy(orderSpecifier);
        }
    }
}
