package com.elitescloud.cloudt.system.model.vo.resp.org;

import cn.hutool.core.text.CharSequenceUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * 员工列表查询信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/19
 */
@Data
@ApiModel(description = "员工列表查询信息")
public class EmployeeListRespVO implements Serializable {
    private static final long serialVersionUID = -3613035963565758589L;

    /**
     * 员工ID
     */
    @ApiModelProperty(value = "员工ID", position = 1)
    private Long id;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID", position = 2)
    private Long userId;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号", position = 3)
    private String code;

    /**
     * 职务
     */
    @ApiModelProperty(value = "职务", position = 3)
    private String duty;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号", position = 4)
    private String username;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 5)
    private String fullName;
    @ApiModelProperty(hidden = true)
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private String lastName;
    @ApiModelProperty(hidden = true)
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private String firstName;
    /**
     * 电话
     */
    @ApiModelProperty(value = "电话", position = 8)
    private String mobile;


    /**
     * 电话
     */
    @ApiModelProperty(value = "办公电话", position = 8)
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", position = 9)
    private String email;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "工作邮箱", position = 9)
    private String emailWork;

    /**
     * 是否没有登录账号
     */
    @ApiModelProperty(value = "是否没有登录账号,默认否", position = 3)
    private Boolean withoutLoginAccount;

    public String getFullName() {
        if (!StringUtils.hasText(lastName)) {
            return firstName;
        }

        return lastName + CharSequenceUtil.blankToDefault(firstName, "");
    }
}
