package com.elitescloud.cloudt.system.model.vo.resp.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 组织列表.
 *
 * @author Kaiser（wang shao）
 * 2022/10/28
 */
@ApiModel(description = "组织列表")
@Data
public class OrgPagedRespVO implements Serializable {
    private static final long serialVersionUID = -8712643087201318524L;

    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID", position = 1)
    private Long id;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织编码", position = 2)
    private String code;

    @ApiModelProperty(value = "外部组织编码", position = 2)
    private String outerCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", position = 3)
    private String name;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称", position = 4)
    private String shortName;

    /**
     * 上级组织编码
     */
    @ApiModelProperty(value = "上级组织编码", position = 5)
    private String parentCode;

    /**
     * 上级组织名称
     */
    @ApiModelProperty(value = "上级组织名称", position = 5)
    private String parentName;

    /**
     * 类型
     */
    @ApiModelProperty(value = "类型[UDC]cloudt-system:orgType", position = 6)
    private String type;

    /**
     * 类型名称
     */
    @ApiModelProperty(value = "类型名称", position = 6)
    private String typeName;

    /**
     * 所属公司
     */
    @ApiModelProperty(value = "所属公司", position = 7)
    private String ouName;

    /**
     * 是否行政组织
     */
    @ApiModelProperty(value = "是否行政组织", position = 8)
    private Boolean executive;

    /**
     * 是否实体组织
     */
    @ApiModelProperty(value = "是否实体组织", position = 9)
    private Boolean entity;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 10)
    private Integer sortNo;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 11)
    private Boolean enabled;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", position = 12)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "特定上级ID", position = 21)
    private Long withParentId;

    @ApiModelProperty(value = "特定上级编码", position = 21)
    private String withParentCode;

    @ApiModelProperty(value = "特定上级名称", position = 21)
    private String withParentName;
}
