package com.elitescloud.cloudt.system.model.vo.resp.sys;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 账户类型.
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/10 周二
 */
@Getter
@Setter
public class UserTypeRespVO implements Serializable {
    private static final long serialVersionUID = 4323280017711206097L;

    @ApiModelProperty(value = "账户类型")
    private String type;

    @ApiModelProperty(value = "账户类型名称")
    private String typeName;

    @ApiModelProperty(value = "身份ID")
    private String identityId;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    public UserTypeRespVO() {
    }

    public UserTypeRespVO(String type, String typeName) {
        this.type = type;
        this.typeName = typeName;
    }

    public UserTypeRespVO(String type, String typeName, String identityId) {
        this.type = type;
        this.typeName = typeName;
        this.identityId = identityId;
    }
}
